#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//low-step raymarchingMod01.fsh   by   abje
//https://www.shadertoy.com/view/MlyBzG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define maxdist 20.0
#define steps 5
#define antialiasing 1

#define rot(spin) mat2(cos(spin),sin(spin),-sin(spin),cos(spin))

//random function by romasm
//https://www.shadertoy.com/view/4scfz4
float seed = 0.0;
vec2 fragUV = vec2(0.0);
float rand() 
{
	float r = fract(sin(dot(fragUV, vec2(12.9898, 78.233)) + seed) * 43758.5453);
	seed++;
    return r;    
}

//a sphere intersection function from iq
//https://www.shadertoy.com/view/4djSDy
vec2 sphIntersect( in vec3 ro, in vec3 rd, float size)
{
	float b = dot( ro, rd );
	float c = dot( ro, ro )-size*size;
	float h = b*b - c;
	if( h<0.0 ) return vec2(99999);
	return vec2(-b-sqrt(h),-b+sqrt(h));
}

//same function but i changed vec3 with vec2
vec2 sphIntersect( in vec2 ro, in vec2 rd, float size)
{
	float b = dot( ro, rd );
	float c = dot( ro, ro )-size*size;
	float h = b*b - c;
	if( h<0.0 ) return vec2(99999);
	return vec2(-b-sqrt(h),-b+sqrt(h));
}

vec3 texture2(vec3 p, vec3 n) {
    vec3 c = cos(p*3.0-n);
    vec3 s = sin(p*3.0+n*3.0);
    
    vec3 col = s*c.yzx*0.5+0.5;
    col *= dot(n,normalize(vec3(-1)))*0.5+0.5;
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    fragUV = fragCoord / iResolution.xy;
    seed = iTime;
    
    vec3 acc = vec3(0);
    for (int aa = 0; aa < antialiasing; aa++) {
#if antialiasing==1
        vec2 uv = (fragCoord*2.0-iResolution.xy)/iResolution.y;
#else
        vec2 uv = ((fragCoord+vec2(rand(),rand()))*2.0-iResolution.xy)/iResolution.y;
#endif

        vec3 rd = normalize(vec3(uv,1));
        vec3 ro = vec3(0.5,0.5,iTime);
        
        if (length(iMouse.xy) > 40.0) {
            rd.yz *= rot(iMouse.y/iResolution.y*3.14-3.14*0.5);
            rd.xz *= rot(iMouse.x/iResolution.x*3.14*2.0-3.14);
        }
        
        vec3 ird = 1.0/vec3(length(rd.yz),length(rd.xz),length(rd.xy));

        float dist = 0.0;
        vec3 n = vec3(0,0,-1);
        for (int i = 0; i < steps; i++) {
            vec3 p = fract(ro+rd*dist)-0.5;

            vec2 a = vec2(-1,1);
            float l = 0.0;

            //for cylinder normals
            vec3 mask = vec3(1);

            vec2 d = sphIntersect(p,rd,0.58);
            if (d.x < 0.0) {
                l = d.y;
            }

            d = sphIntersect(p.yz,rd.yz*ird.x,0.4)*ird.x;
            if (d.x < 0.0 && d.y > l) {
                mask = vec3(0,1,1);
                l = d.y;
            }

            d = sphIntersect(p.xz,rd.xz*ird.y,0.4)*ird.y;
            if (d.x < 0.0 && d.y > l) {
                mask = vec3(1,0,1);
                l = d.y;
            }

            d = sphIntersect(p.xy,rd.xy*ird.z,0.4)*ird.z;
            if (d.x < 0.0 && d.y > l) {
                mask = vec3(1,1,0);
                l = d.y;
            }

            if (l > 0.0) {
                dist += l;
                p += rd*l;
                n = -p*mask;
            } else {
                break;
            }
        }

        vec3 background = vec3(0.2);
        vec3 col = background;

        if (dist < maxdist) {
            vec3 p = ro+rd*dist;

            n = normalize(n);
			
            col = texture2(p, n);

            col = mix(col,background,sqrt(dist/maxdist));
        }
        acc += col;
    }
    
    
    
    fragColor = vec4(sqrt(acc/float(antialiasing)),1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

